/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.pssim;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWCapsule;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.att.IWSAttSession;
import filenet.ws.utils.att.IWSDocUpdater;
import java.io.File;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.http.HTTPConstants;

public class AttachmentHandler
extends BasicHandler {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.pssim");
    protected static final String m_className = "AttachmentHandler";
    private IWSAttSession m_WSAttSession = null;
    private String[] m_fileNames = null;
    private int m_nAtts = 0;
    private String m_username = null;
    private String m_pw = null;
    private String m_docId = null;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 18:23:34  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        String m_method = "invoke";
        logger.entering(m_className, "invoke");
        try {
            this.processAttachment(msgContext);
        }
        catch (Exception e) {
            AxisFault retFault = AxisFault.makeFault((Exception)e);
            logger.throwing(m_className, "invoke", retFault);
            throw retFault;
        }
        finally {
            logger.exiting(m_className, "invoke");
        }
    }

    private static File getP8ConfigFile(String s) {
        try {
            String m_method = "getP8ConfigFile";
            if (s == null) {
                return null;
            }
            File f = new File(s);
            File pf = f.getParentFile();
            String myFile = pf.getCanonicalPath() + File.separator + "WcmApiConfig.properties";
            File thisFile = new File(myFile);
            if (thisFile.exists()) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "getP8ConfigFile", "Use: " + myFile);
                }
                return thisFile;
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "getP8ConfigFile", "Not Exists: " + myFile);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private void getWSAttSession(MessageContext msgContext) throws Exception {
        String m_method = "getWSAttSession";
        try {
            HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            if (req == null) {
                throw new VWException("filenet.ws.listener.axis.ValidatorHandler.invalidState", "Invalid Invocation:  Should be a post.");
            }
            WSListenerProperties props = (WSListenerProperties)req.getAttribute("P8BPM.wsListenerProperties");
            if (props != null) {
                String configFile = props.getFullPath();
                if (this.m_username == null || this.m_username.trim().length() == 0) {
                    this.m_username = props.getUserName();
                    this.m_pw = props.getPassword();
                    if (this.m_username == null || this.m_pw == null) {
                        throw new VWException("filenet.ws.listener.pssim.AttachmentHandler.noCredentialsDefinedYet", "Credentials are not yet defined.  Please use Task Manager to define the credentials in Component Manager.");
                    }
                }
                if (this.m_username != null) {
                    String handlerClassName = props.getProperty("att.handler");
                    if (handlerClassName == null) {
                        handlerClassName = "filenet.vw.idm.trident.WSSession";
                    }
                    Class<?> handlerClass = Class.forName(handlerClassName);
                    this.m_WSAttSession = (IWSAttSession)handlerClass.newInstance();
                    this.m_WSAttSession.setCredentials(this.m_username, this.m_pw, AttachmentHandler.getP8ConfigFile(configFile));
                }
            }
        }
        catch (Exception t) {
            logger.throwing(m_className, "getWSAttSession", t);
            throw t;
        }
    }

    private void parseMessageBody(SOAPBody body) throws Exception {
        String m_method = "parseMessageBody";
        Iterator iter = body.getChildElements();
        SOAPBodyElement el = (SOAPBodyElement)iter.next();
        String s = el.getElementName().getLocalName();
        if (s.compareTo("updateDocRequest") != 0) {
            return;
        }
        Iterator childIter = el.getChildElements();
        boolean noEnc = false;
        while (childIter.hasNext()) {
            String elValue;
            SOAPElement childEl = (SOAPElement)childIter.next();
            String elName = childEl.getElementName().getLocalName();
            if (logger.isFinest()) {
                logger.finest(m_className, "parseMessageBody", elName);
            }
            if ((elValue = childEl.getValue()) != null) {
                elValue = elValue.trim();
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "parseMessageBody", elName + "=" + elValue);
            }
            if (elName.equals("docId")) {
                this.m_docId = elValue;
            }
            if (elName.equals("noenc")) {
                noEnc = true;
            }
            if (elName.equals("name")) {
                this.m_username = elValue;
            }
            if (elName.equals("sess")) {
                this.m_pw = elValue;
            }
            if (!elName.startsWith("file")) continue;
            String no = elName.substring(4);
            try {
                int AttNo = Integer.parseInt(no);
                if (AttNo >= this.m_nAtts) continue;
                this.m_fileNames[AttNo] = elValue;
            }
            catch (Exception e) {
                logger.throwing(m_className, "parseMessageBody", e);
                throw e;
            }
        }
        if (!noEnc) {
            VWCapsule cap1 = new VWCapsule();
            cap1.setString(this.m_username);
            this.m_username = cap1.getString();
            VWCapsule cap2 = new VWCapsule();
            cap2.setString(this.m_pw);
            this.m_pw = cap2.getString();
        }
        if (this.m_docId == null || this.m_docId.length() == 0) {
            VWException ex = new VWException("filenet.ws.listener.pssim.AttachmentHandler.invalidParameters", "Invalid Parameters");
            logger.throwing(m_className, "parseMessageBody", ex);
            throw ex;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "parseMessageBody", this.m_username + "," + this.m_docId);
        }
    }

    private void processAttachment(MessageContext msgContext) throws Exception {
        String m_method = "processAttachment";
        logger.entering(m_className, "processAttachment");
        try {
            Message msg = msgContext.getRequestMessage();
            this.m_nAtts = msg.countAttachments();
            if (this.m_nAtts == 0) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "processAttachment", "Message has no attachments..");
                }
                return;
            }
            this.m_fileNames = new String[this.m_nAtts];
            this.parseMessageBody(msg.getSOAPPart().getEnvelope().getBody());
            this.getWSAttSession(msgContext);
            Iterator attIter = msg.getAttachments();
            AttachmentPart[] attParts = new AttachmentPart[this.m_nAtts];
            int i = 0;
            while (attIter.hasNext()) {
                if (this.m_fileNames[i] == null) {
                    throw new Exception("missing fileName for attachment");
                }
                attParts[i++] = (AttachmentPart)attIter.next();
            }
            IWSDocUpdater updater = this.m_WSAttSession.getDocUpdater(this.m_docId);
            updater.checkin(attParts, this.m_fileNames);
        }
        catch (Exception e) {
            logger.throwing(m_className, "processAttachment", e);
            throw e;
        }
        finally {
            logger.exiting(m_className, "processAttachment");
        }
    }
}

